<?php
/**
 * Управление скачиванием файлов
 *
 * @version 0.1
 * @link http://www.simplecoding.org
 * @author Стаценко Владимир <vova_33@gala.net>
 */
class Main extends Controller {

	function Main() {
		parent::Controller();
		$this->load->helper('file');
		$this->load->config('downloader');
	}

	/**
	 * Формирует главную страницу со списком файлов
	 */
	function index() {
		$pageData['title'] = 'Управление скачиванием файлов';
		$pageData['files'] = get_filenames($this->config->item('filesdir'));
		
		$this->load->view('header', $pageData);
		$this->load->view('filelist');
		$this->load->view('footer');
	}
	
	/**
	 * Формирует страницу с каптчей, которую должен 
	 * ввести посетитель чтобы скачать файл
	 *
	 * @param $fileName - имя файла, который пользователь хочет загрузить
	 */
	function confirm($fileName = '') {
		session_start();
		
		//если посетитель ввел каптчу
		if ($this->input->post('captcha')) {
			//проверяем ответ на вопрос
			if ((int)$this->input->post('captcha') === $_SESSION['captcha']) {
				//создаем временную ссылку
				//сохраняем её в базе
				$this->load->model('mfilelink');
				
				$fileLink = $this->mfilelink->createLink($fileName);
				//если ссылка создана и сохранена
				if ($fileLink) {
					//отправляем посетителя на страницу загрузки файла
					redirect($fileLink, 'refresh');
					exit;
				}
				//если нет - создаем сообщение об ошибке и перенаправляем посетителя на страницу
				//со списком файлов
				else {
					$this->session->set_flashdata('error', 'Извините, этот файл не может быть загружен.');
					redirect('main/index', 'refresh');
					exit;
				}
			}
			//если посетитель неправильно ввел каптчу
			else {
				$this->session->set_flashdata('error', 'Вы неправильно ответили на вопрос. Попробуйте ещё раз.');
				redirect('main/confirm/'.$fileName, 'refresh');
				exit;
			}
		}
		
		//игнорируем запросы к несуществующим файлам
		if (!get_file_info($this->config->item('filesdir').'/'.$fileName)) {
			redirect('main/index', 'refresh');
			exit;
		}
		
		$this->load->helper('form');
		
		//подготавливаем данные для каптчи
		$x = mt_rand(1, 9);
		$y = mt_rand(1, 9);
		
		$_SESSION['captcha'] = $x + $y;
		
		//формируем страницу
		$pageData['title'] = 'Управление скачиванием файлов';
		$pageData['fileName'] = $fileName;
		$pageData['x'] = $x;
		$pageData['y'] = $y;
		
		$this->load->view('header', $pageData);
		$this->load->view('confirm');
		$this->load->view('footer');
	}
}
?>