<?php
/**
 * Эта модель предназначена для работы с временными ссылками на файлы
 *
 * @link http://www.simplecoding.org
 * @author Стаценко Владимир <vova_33@gala.net>
 */
class MFileLink extends Model {

	function MFileLink() {
		parent::Model();
	}
	
	/**
	 * Создает временную ссылку и добавляет ее в текстовый файл
	 *
	 * @param $fileName - имя файла
	 * @return ссылку, если она создана, false - если возникла ошибка
	 */
	function createLink($fileName) {
		$userIP = $_SERVER['REMOTE_ADDR'];
		
		//проверяем существование файла
		if (!get_file_info($this->config->item('filesdir').'/'.$fileName)) {
			return false;
		}

		if (write_file('templinks.txt', $userIP.'-'.$fileName.' '
			.date('YmdHis', time() + $this->config->item('linktime')).PHP_EOL, 'a')) {
			return 'archive/'.$fileName;
		}
		else {
			return false;
		}
	}
}
?>